;;; - ------------------------------------------------------------------------------ - ;
;;; -                A C M - S E L E C T B Y S C A L E                               - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Beschreibung : Auswahl von Objekten gleichen Annotationsmastabes              - ;
;;; - Befehle      : ACM-SELECTBYSCALE                                               - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - letzte nderung am : 28.12.2022                                                - ;
;;; -              durch : Thomas Krger                                             - ;
;;; - ------------------------------------------------------------------------------ - ;
(vl-load-com)
;;; - ------------------------------------------------------------------------------ - ;
(defun C:ACM-SELECTBYSCALE(/ SCALESELECTDLG SCALESELECT
                             FLAGS SCALES MODUS AWS NOMUTT
                          )
  
  (defun SELECTBYSCALEDLG(/ DT:SCALE-GETALL WRITE-DCL DT:LISTBOX:CHECK DLG-CHECK DLG-RUN
                            DLG FLAGS SCALE:LIST SCALE:AWS
                         )
    (defun DT:SCALE-GETALL(/ DICT DICTNAME DICTOBJ DATA NAME PAPERUNIT DRAWINGUNIT LISTE)
      (if(setq DICT(dictsearch (namedobjdict) "ACAD_SCALELIST"))
        (while (setq DICT (member(assoc 3 DICT)DICT))
          (if(and(setq DICTNAME (cdr(car DICT)))
                 (setq DICTOBJ  (cadr DICT))
                 (= 350 (car DICTOBJ))
                 (=(type(setq DICTOBJ(cdr DICTOBJ)))'ENAME)
                 (setq DATA(entget DICTOBJ))
                 (setq NAME       (cdr(assoc 300 DATA)))
                 (setq NAME              (strcase NAME))
                 (setq PAPERUNIT  (cdr(assoc 140 DATA)))             
                 (setq DRAWINGUNIT(cdr(assoc 141 DATA)))
             )
            (progn
              (if(and(numberp PAPERUNIT)
                     (numberp DRAWINGUNIT)
                     (< 0 PAPERUNIT)
                     (< 0 DRAWINGUNIT)
                 )    
                (setq FAKTOR (/ PAPERUNIT DRAWINGUNIT 1.0))
              )       
              (setq LISTE (cons
                            (list NAME DICTOBJ PAPERUNIT DRAWINGUNIT DICTNAME FAKTOR)
                            LISTE
                          )
              )
            )  
          )
          (setq DICT (cdr DICT))
        )  
      )
      (reverse LISTE)
    )
    (defun WRITE-DCL(/ DIR FILE)
      (if(and(setq DIR(vl-filename-mktemp "SCALEAWS.DCL"))
             (setq FILE (open DIR "w"))
         )    
        (progn
          (mapcar
           '(lambda (X)(princ (strcat X "\n") FILE))
           '(             
             "DLGSCALEAWS"
             ": dialog"
             "   { key = DLGTITEL;"
             "     : boxed_column"
             "     {"
             "       : text"
             "       { label       = \"Mastbe:\";"
             "         key         = \"SCALE-LISTTXT\";"
             "         width       = 35;"
             "         fixed_width = true;"                        
             "         alignment = left;"
             "       }"
             "       : list_box"
             "       { key         = \"SCALE-LIST\";"
             "         width       = 35;"
             "         fixed_width = true;"
             "         height      = 10;"
             "         fixed_height= true;"
             "         multiple_select = true;"
             "         alignment = left;"
             "       }"
             "       : spacer {}"
             "       : radio_row"         
             "       { label = \"Mastabsreferenzierung:\";"
             "         width       = 35;"
             "         fixed_width = true;"
             "         children_alignment = right;"            
             "         : radio_button"
             "         { label = \"mind. Einen\";"
             "           key   = \"FLAG1\";"
             "           alignment = centered;"
             "         }" 
             "         : radio_button"
             "         { label = \"Alle \";"
             "           key   = \"FLAG2\";"
             "           alignment = centered;"
             "         } "
             "       }"
             "     }"
             "     : row"
             "     {"        
             "       : button"
             "       { label=\"OK\";"
             "         key=\"OK\";"
             "         fixed_width=true;"
             "         width=11;"
             "         alignment=centered;"
             "         mnemonic =\"O\";"
             "         is_default = true;"
             "       }"
             "       : cancel_button"
             "       { label = \"Abbruch\";"
             "         key = \"CANCEL\";"
             "         fixed_width = true;"
             "         width = 11;"
             "         alignment = centered;"
             "         mnemonic =\"A\";"
             "         is_cancel = true;"
             "       }"
             "       : button"
             "       { label = \"Info\";"
             "         key = \"INFO\";"
             "         fixed_width = true;"
             "         width = 11;"
             "         alignment = centered;"
             "         mnemonic =\"I\";"
             "       }"
             "     }"
             "   }"
            )  
          )
          (close FILE)
          DIR
        )
      )
    )
    (defun DT:LISTBOX:CHECK(SELECTED BASISLIST / INDEXLIST  POS)
      (if(and(=(type SELECTED)'STR)(=(type BASISLIST)'LIST))    
        (progn      
          (while (setq POS(vl-string-search " " SELECTED))
            (setq INDEXLIST(cons (substr SELECTED 1 POS) INDEXLIST)
                  SELECTED (substr SELECTED (+ POS 2))              
            )
          )      
          (if(and(setq INDEXLIST
                   (vl-remove-if-not '(lambda(Z / Y)
                                        (and(setq Y(atoi Z))(= Y (distof Z 2))
                                            (<= 0 Y)(< Y (length BASISLIST))
                                        )
                                      )  
                                      (reverse(cons SELECTED INDEXLIST))
                   )
                 )
                 (setq SELECTED(mapcar'(lambda(Y)(nth Y BASISLIST))(mapcar 'atoi INDEXLIST)))
             )                       
            SELECTED          
          )  
        )
      )    
    )
    (defun DLG-CHECK( / FLAGS )    
      (list (DT:LISTBOX:CHECK
              (get_tile "SCALE-LIST")
              SCALE:LIST
            )
            (atoi(get_tile "FLAG1"))
      )
    )
    (defun DLG-RUN(DIR / DLGINDEX FLAGS NAME ITEM)
      (if(and(setq DIR(findfile DIR))(>(setq DLGINDEX (load_dialog DIR))0))
        (if(new_dialog "DLGSCALEAWS" DLGINDEX)
          (progn
            (or(member MODUS   '("1" "0"))(setq MODUS   "1"))
            (setq SCALE:LIST(mapcar 'car (DT:SCALE-GETALL)))
            (if(>(length SCALE:LIST)1) (setq SCALE:LIST(vl-sort SCALE:LIST '<)))
            (set_tile    "DLGTITEL" "ACM-SELECTBYSCALE")          
            (start_list  "SCALE-LIST" 3)(mapcar 'add_list  SCALE:LIST)(end_list)
            (set_tile    "FLAG1" MODUS)
            (set_tile    "FLAG2" (itoa(- 1 (atoi MODUS))))
            (action_tile "SCALE-LIST""(setq SCALE:AWS (DT:LISTBOX:CHECK $VALUE SCALE:LIST))")
            (action_tile "OK"        "(if(setq FLAGS (DLG-CHECK))(done_dialog 1))")
            (action_tile "CANCEL"    "(setq FLAGS            nil)(done_dialog 0)")
            (action_tile "INFO"      "(alert(strcat \"=======  ACM-SELECTBYSCALE  =======\n\n\"
                                                    \"   Objektwahl nach Mastab\n\"
                                                    \"  Th.Krger 2022 (tk@cad-od.de)\n\"
                                            )
                                      )"      
            )
            (start_dialog)
            (unload_dialog DLGINDEX)            
          )
          (alert "Dialog nicht gefunden")
        )
        (alert "Dialog nicht gefunden")
      )  
      FLAGS
    )    
    (if(>=(atof(getvar "ACADVER"))16.2)
      (if(setq DLG(WRITE-DCL))
        (progn
          (setq FLAGS(DLG-RUN DLG))          
          (vl-file-delete DLG)
          FLAGS
        )  
      )
      (alert "\nMastbe werden erst ab Autocad 2008 untersttzt.")
    )  
  )
  ;;; - ---------------------------------------------------------------------------- - ;
  (defun SELECTBYSCALE (AWS SCALES MODUS / LISTE OBJS)
    (if(and(=(type AWS)'PICKSET)(=(type SCALES)'LIST)
           (setq SCALES(mapcar
                         'strcase(vl-remove-if-not'(lambda(X)(=(type X)'STR))SCALES)
                       )
           )
           (setq OBJS
             (vl-remove-if 'null     
             (mapcar
              '(lambda(X / OBJ DICT OBJSCALES)
                 (if(and(=(type(setq OBJ(cadr X)))'ENAME)
                        (setq DICT (cdr (assoc 360 (entget OBJ))))
                        (setq DICT (dictsearch DICT "AcDbContextDataManager"))
                        (setq DICT (dictsearch (cdr(assoc -1 DICT)) "ACDB_ANNOTATIONSCALES"))
                        (setq DICT (vl-remove-if-not '(lambda(Y)(=(car Y)350))DICT))
                        (setq OBJSCALES(mapcar
                                         '(lambda(Z / D)
                                            (if(and(=(type(setq D(cdr Z)))'ENAME)
                                                   (setq D(entget D))
                                                   (=(type(setq D(cdr(assoc 340 D))))'ENAME)
                                                   (setq D(entget D))
                                                   (=(type(setq D(cdr(assoc 300 D))))'STR)
                                               )
                                              (strcase D)
                                            )
                                          )   
                                          DICT
                                       )  
                        )
                        (cond
                          ((= MODUS 1)(< 0 (length(vl-remove-if
                                                    'null
                                                    (mapcar
                                                      '(lambda(S)(member S OBJSCALES))
                                                       SCALES
                                                    )
                                                  )
                                           )       
                                      )
                          ) 
                          ((= MODUS 0)(vl-every '(lambda(S)(member S OBJSCALES)) SCALES))
                        )  
                    )
                   (list OBJ OBJSCALES)
                 )
               )  
               (ssnamex AWS)
             ))
           )
       )    
      (progn           
        (setq AWS(ssadd))
        (mapcar '(lambda(X)(ssadd (car X) AWS)) OBJS)
        AWS
      )       
    )
  )  
  ;;; - ---------------------------------------------------------------------------- - ;
  (if(and(or(and(setq AWS (ssget "I" (list(cons 410 (getvar "CTAB")))))
                (or(>(sslength AWS)0)
                   (princ(strcat "\nKeine Objekte gewhlt.."))
                )
            )    
            (initget "Ja Nein")
            (if(/=(getkword "\nGanze Zeichnung? [Ja / Nein] <Ja>: ") "Nein")       
              (and(setq AWS (ssget "_X" (list (cons 410 (getvar "CTAB")))))
                  (or(>(sslength AWS)0)
                     (princ(strcat "\nKeine Objekte gewhlt.."))
                  )
              )
              (and(setq NOMUTT(getvar "NOMUTT"))
                  (setvar "NOMUTT" 1)
                  (princ "\nBeschriftungsobjekte whlen: ")
                  (or(vl-catch-all-error-p
                       (setq AWS(vl-catch-all-apply
                                  'ssget (list(list (cons 410 (getvar "CTAB"))))
                                ) 
                       )
                     )
                     'T
                  )
                  (setvar "NOMUTT" NOMUTT)
                  (or(=(type AWS)'PICKSET)
                     (prompt "\nAbbruch durch Anwender...")
                  )   
                  (or(>(sslength AWS)0)
                     (princ(strcat "\nKeine Objekte gewhlt.."))
                  )   
              )
            )  
            (prompt "\nKeine Beschriftungsobjekte in der Auswahl .....")
         )       
         (setq FLAGS(SELECTBYSCALEDLG))
         (or(setq SCALES(car FLAGS))
            (prompt "\nKeine auszuwhlenden Mastbe angegeben...")
         )
         (or(setq AWS(SELECTBYSCALE AWS SCALES (cadr FLAGS)))
            (prompt "\nKeine Objekte mit angegebenen Mastben gefunden...")
         )   
     )
    (progn
      (princ(strcat "\n" (rtos(sslength AWS)2 0) " TopLevel-Objekte gefunden.."))
      (sssetfirst AWS AWS)
      (princ)
    )
    (progn      
      (sssetfirst nil nil)
      (princ)
    )  
  )
)  
;;; -------------------------------------------------------------------------------- - ;
(defun ACM-SELECTBYSCALE:INFO() 
  (mapcar
    'princ
    (list
      "\n\n"
      "\nACM-SELECTBYSCALE: Auswahl von Objekten gleichen Annotationsmastabes"
      "\n================== "
      "\n(C) Thomas Krger 2022 (tk@cad-od.de)"
      "\nBefehlszeilenaufruf :  ACM-SELECTBYSCALE\n"
      "\n"    
    )
  )
  (princ)  
)
;;; - ------------------------------------------------------------------------------ - ;
(ACM-SELECTBYSCALE:INFO)
(princ)






